#!/bin/bash

# 定义安装命令的函数，接收 user 和 repo 作为参数
case "$(uname -m)" in
  x86_64)
    arch="amd64"
    ;;
  aarch64)
    arch="arm64"
    ;;
  *)
    echo "Unsupported architecture: $(uname -m)"
    exit 1
    ;;
esac

if [ "$2" = "-U" ]; then
  case "$1" in
    "helm" | "k9s" | "govc" | "nerdctl" | "fzf" | "terraform" | "packer" )
      rm -rf /usr/local/bin/"$1" "${fpath[0]}"/_"$1" /etc/bash_completion.d/"$1"
      echo
      echo "-------------------------------------------"
      echo "$1 installation complete!"
      echo
      echo "-------------------------------------------"
      echo
      ;;
    "trzsz" )
      rm -rf /usr/local/bin/"trzsz" /usr/local/bin/"trz" /usr/local/bin/"tsz" "${fpath[0]}"/_"$1" /etc/bash_completion.d/"trzsz"
      echo
      echo "-------------------------------------------"
      echo "$1 installation complete!"
      echo
      echo "-------------------------------------------"
      echo
      ;;
    *)
      echo "Unsupported package: $1"
      exit 1
      ;;
  esac
  exit 0
else
  case "$1" in
    "helm")
      # helm
      echo
      echo "Installing helm..."
      version=$(curl -s https://get.helm.sh/helm-latest-version)
      curl -s -L -o - "https://get.helm.sh/helm-${version}-linux-${arch}.tar.gz" | tar --strip-components=1 -C /usr/local/bin -xzf - linux-amd64/helm
      helm completion zsh > "${fpath[1]}/_helm" || true
      helm completion bash > /etc/bash_completion.d/helm
      # Displaying post-installation instructions
      echo
      echo "-------------------------------------------"
      echo "helm installation complete!"
      echo
      # Displaying version
      helm version
      echo
      echo "-------------------------------------------"
      echo
      ;;
    "k9s")
    # derailed k9s
      echo
      echo "Installing k9s..."
      curl -s -L -o - "https://github.com/derailed/k9s/releases/latest/download/k9s_Linux_${arch}.tar.gz" | tar -C /usr/local/bin -xzf - k9s
      # Displaying post-installation instructions
      echo
      echo "-------------------------------------------"
      echo "k9s installation complete!"
      echo
      # Displaying version
      k9s version
      echo
      echo "-------------------------------------------"
      echo
      ;;
    "govc")
      # vmware govmomi
      echo
      echo "Installing govmomi..."
      curl -s -L -o - "https://github.com/vmware/govmomi/releases/latest/download/govc_$(uname -s)_$(uname -m).tar.gz" | tar -C /usr/local/bin -xvzf - govc
      # Displaying post-installation instructions
      echo
      echo "-------------------------------------------"
      echo "nerdctl installation complete!"
      echo
      # Displaying version
      govc version
      echo
      echo "To initialize the environment, please run:"
      echo "    export GOVC_URL=\"https://administrator@vsphere.local:password@vcip\""
      echo "    export GOVC_INSECURE=true"
      echo "-------------------------------------------"
      echo
      ;;
    "nerdctl")
      # vmware nerdctl
      echo
      echo "Installing nerdctl..."
      VERSION=$(curl -s https://api.github.com/repos/containerd/nerdctl/releases/latest | jq -r '.tag_name' | awk -F"v" '{print $NF}')
      curl -s -L -o - "https://github.com/containerd/nerdctl/releases/latest/download/nerdctl-${VERSION}-linux-${arch}.tar.gz" | tar -C /usr/local/bin -xvzf - nerdctl
      nerdctl completion zsh > "${fpath[1]}/_nerdctl" || true
      nerdctl completion bash > /etc/bash_completion.d/nerdctl
      # Displaying post-installation instructions
      echo
      echo "-------------------------------------------"
      echo "nerdctl installation complete!"
      echo
      # Displaying version
      nerdctl version
      echo
      echo "-------------------------------------------"
      echo
      ;;
    "fzf")
      # fzf
      echo
      echo "Installing fzf..."
      VERSION=$(curl -s https://api.github.com/repos/junegunn/fzf/releases/latest | jq -r '.tag_name' | awk -F"v" '{print $NF}')
      curl -s -L -o - "https://github.com/junegunn/fzf/releases/latest/download/fzf-${VERSION}-linux_${arch}.tar.gz" | tar -C /usr/local/bin -xvzf - fzf
      fzf --zsh > "${fpath[1]}/_fzf" || true
      fzf --bash > /etc/bash_completion.d/fzf
      # Displaying post-installation instructions
      echo
      echo "-------------------------------------------"
      echo "fzf installation complete!"
      echo
      # Displaying version
      fzf --version
      echo
      echo "-------------------------------------------"
      echo
      ;;
    "terraform")
      # terraform
      echo
      echo "Installing Terraform..."    
      # Fetching the latest version of Terraform
      VERSION=$(curl -s https://checkpoint-api.hashicorp.com/v1/check/terraform | jq -r -M '.current_version')
      curl -s -L -o "terraform_${VERSION}_linux_${arch}.zip" "https://releases.hashicorp.com/terraform/${VERSION}/terraform_${VERSION}_linux_${arch}.zip"    
      # Unzipping and installing Terraform
      unzip -qq -o "terraform_${VERSION}_linux_${arch}.zip" terraform -d /usr/local/bin && rm -f "terraform_${VERSION}_linux_${arch}.zip"        
      # Displaying post-installation instructions
      echo
      echo "-------------------------------------------"
      echo "Terraform installation complete!"
      echo
      # Displaying terraform version
      terraform --version
      echo
      echo "To enable CLI auto-completion, please run:"
      echo "    terraform -install-autocomplete"
      echo "-------------------------------------------"
      echo
      ;;
    "packer")
      # packer
      echo
      echo "Installing Packer..."    
      # Fetching the latest version of packer
      VERSION=$(curl -s https://checkpoint-api.hashicorp.com/v1/check/packer | jq -r -M '.current_version')
      curl -s -L -o "packer_${VERSION}_linux_${arch}.zip" "https://releases.hashicorp.com/packer/${VERSION}/packer_${VERSION}_linux_${arch}.zip"    
      # Unzipping and installing packer
      unzip -qq -o "packer_${VERSION}_linux_${arch}.zip" packer -d /usr/local/bin && rm -rf "packer_${VERSION}_linux_${arch}.zip" /usr/sbin/packer
      # Displaying post-installation instructions
      echo
      echo "-------------------------------------------"
      echo "Packer installation complete!"
      echo
      # Displaying packer version
      packer --version
      echo
      echo "To enable CLI auto-completion, please run:"
      echo "    packer -autocomplete-install"
      echo "-------------------------------------------"
      echo
      ;;
    "trzsz")
      # trzsz
      echo
      echo "Installing trzsz..."
      curl -s -L -o - "https://github.com/trzsz/trzsz-go/releases/download/v1.1.8/trzsz_1.1.8_linux_$(uname -m).tar.gz" | tar --strip-components=1 -C /usr/local/bin -xvzf -
      # Displaying post-installation instructions
      echo
      echo "-------------------------------------------"
      echo "trzsz installation complete!"
      echo
      # Displaying version
      /usr/local/bin/trzsz version
      echo
      ;;
    *)
      echo
      echo "helm k9s govc nerdctl fzf terraform packer trzsz"
      exit 1
      ;;
  esac
  exit 0
fi