#!/bin/bash

git status

echo
read -p "Type 'y' to confirm reset and pull (Enter = yes, n = cancel): " confirm </dev/tty

# Treat empty input (Enter) as "y"
confirm="${confirm:-y}"

if [[ "$confirm" == "y" ]]; then
    echo "Proceeding with reset and pull..."
    git reset --hard HEAD && git clean -fd && git fetch origin && git pull origin main
    git status
elif [[ "$confirm" == "n" ]]; then
    echo "Operation cancelled by user (n)."
else
    echo "Operation cancelled. Only 'y' or Enter will proceed."
fi