#!/bin/bash

# 获取默认网关地址
GATEWAY=$(ip route | awk '/default/ {print $3}' | uniq | head -n 1)

# 创建配置目录
sudo mkdir -p /etc/systemd/system/docker.service.d

# 根据默认网关设置对应的代理地址
case "$GATEWAY" in
  192.168.48.1)
    PROXY="http://192.168.48.48:7891"
    ;;
  172.29.48.1)
    PROXY="http://172.29.48.3:7891"
    ;;
  172.29.16.1)
    PROXY="http://172.29.16.3:7891"
    ;;
  172.29.80.1)
    PROXY="http://172.29.80.3:7891"
    ;;
  172.29.112.1)
    PROXY="http://172.29.112.3:7891"
    ;;
  *)
    echo "未识别的默认网关: $GATEWAY"
    exit 1
    ;;
esac

# 写入 docker 的代理配置
sudo bash -c "cat << UK > /etc/systemd/system/docker.service.d/http-proxy.conf
[Service]
Environment=\"HTTP_PROXY=$PROXY\"
Environment=\"HTTPS_PROXY=$PROXY\"
Environment=\"NO_PROXY=localhost,127.0.0.1,10.0.0.0/8,192.168.0.0/16,10.0.0.0/8,172.29.0.0/16,localhost,registry.smtx.io\"
UK"

# 应用更改
sudo systemctl daemon-reload
sudo systemctl restart docker

# 检查代理配置是否生效
docker info | grep -i proxy
