#!/bin/bash

# install package
if command -v yum &>/dev/null; then
  sudo yum install -y -q git zsh bash-completion wget unzip tree tmux vim sysstat &> /dev/null
elif command -v apt &>/dev/null; then
  sudo apt update -qq
  sudo apt install -y git zsh bash-completion wget unzip tree tmux vim sysstat &> /dev/null
else
  echo "[ERROR] unsupport os" >&2
  exit 1
fi

# install oh-my-zsh
git clone https://mirrors.tuna.tsinghua.edu.cn/git/ohmyzsh.git
REMOTE=https://mirrors.tuna.tsinghua.edu.cn/git/ohmyzsh.git sh ohmyzsh/tools/install.sh && rm -rf ohmyzsh

ZSH=$HOME/.oh-my-zsh
# install zsh-syntax-highlighting
# git clone https://github.com/zsh-users/zsh-syntax-highlighting.git ${ZSH_CUSTOM:-~/.oh-my-zsh/custom}/plugins/zsh-syntax-highlighting
git clone https://mirrors.nju.edu.cn/git/zsh-syntax-highlighting.git $ZSH/custom/plugins/zsh-syntax-highlighting
# echo "source $ZSH_CUSTOM/plugins/zsh-syntax-highlighting/zsh-syntax-highlighting.zsh" >> ${ZDOTDIR:-$HOME}/.zshrc

# install zsh-autosuggestions
# git clone https://github.com/zsh-users/zsh-autosuggestions ${ZSH_CUSTOM:-~/.oh-my-zsh/custom}/plugins/zsh-autosuggestions
git clone https://mirrors.nju.edu.cn/git/zsh-autosuggestions.git $ZSH/custom/plugins/zsh-autosuggestions
# echo "source $ZSH_CUSTOM/plugins/zsh-autosuggestions/zsh-autosuggestions.zsh" >> ${ZDOTDIR:-$HOME}/.zshrc

# replace plugins and theme
cp $HOME/.zshrc $HOME/.zshrc.bak
zsh -c 'source ~/.zshrc && omz plugin enable zsh-autosuggestions zsh-syntax-highlighting sudo'
zsh -c 'source ~/.zshrc && omz theme set ys'
# sed -i 's/(git/(git zsh-syntax-highlighting zsh-autosuggestions sudo/g' ~/.zshrc
# sed -i 's/ZSH_THEME="robbyrussell"/ZSH_THEME="ys"/g' ~/.zshrc

cat >> ~/.zshrc <<UK

## add
zstyle ':omz:update' mode disabled
HIST_STAMPS="yyyy-mm-dd"
alias vi="vim"
UK  