#!/bin/bash

set -o errexit
set -o nounset
set -o pipefail

VM_NEW_NAME=$1

# 提取当前OVF文件名
VM_NOW_NAME=$(basename *.ovf | awk -F '.ovf' '{print $1}')

# 重命名OVF文件和VMDK文件
mv "$VM_NOW_NAME".ovf "$VM_NEW_NAME".ovf
mv "$VM_NOW_NAME"-1.vmdk "$VM_NEW_NAME".vmdk

# 在OVF文件中替换名称
sed -i "s/$VM_NOW_NAME/$VM_NEW_NAME/g" "$VM_NEW_NAME".ovf
sed -i "s/${VM_NEW_NAME}-1/$VM_NEW_NAME/g" "$VM_NEW_NAME".ovf

echo "#### PACKER_COMPLETE ####"

# 脚本执行完以后，删除本脚本
rm -f "$0"