#!/bin/bash

set -o errexit
set -o nounset
set -o pipefail

export TOWER_HOST=$TOWER_HOST
export TOWER_USERNAME=$TOWER_USERNAME
export TOWER_PASSWORD=$TOWER_PASSWORD
export VM_NAME=$VM_NAME
export TOWER_SOURCE=LOCAL

env

# 下载二进制命令并授予执行权限
wget -O /tmp/shutdown-vm http://192.168.48.2/Software/bin/tower/shutdown-vm-alpine
wget -O /tmp/delete-vm http://192.168.48.2/Software/bin/tower/delete-vm-alpine
chmod +x /tmp/shutdown-vm /tmp/delete-vm

# 强制关机
/tmp/shutdown-vm -force -vm $VM_NAME || true

# 删除虚拟机并移入回收站
/tmp/delete-vm -recycle-bin -vm $VM_NAME || true

# 脚本执行完以后，删除本脚本
rm -f "$0"